###
###

.pkgname <- "BSgenome.Athaliana.TAIR.TAIR9"

.seqnames <- paste("Chr", c(1:5, "M", "C"), sep="")

.circ_seqs <- c("ChrM", "ChrC")

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Arabidopsis thaliana",
        species="Arabidopsis",
        provider="TAIR",
        provider_version="TAIR9",
        release_date="June 9, 2009",
        release_name="TAIR9 Genome Release",
        source_url="ftp://ftp.arabidopsis.org/home/tair/Genes/TAIR9_genome_release/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Athaliana"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

