###
###

.pkgname <- "BSgenome.Dmelanogaster.UCSC.dm3"

.seqnames <- paste("chr", c("2L", "2R", "3L", "3R", "4", "X", "U", "M", "2LHet", "2RHet", "3LHet", "3RHet", "XHet", "YHet", "Uextra"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Drosophila melanogaster",
        species="Fly",
        provider="UCSC",
        provider_version="dm3",
        release_date="Apr. 2006",
        release_name="BDGP Release 5",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/dm3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Dmelanogaster"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

