\name{BSgenome.Dmelanogaster.UCSC.dm6}
\docType{package}

\alias{BSgenome.Dmelanogaster.UCSC.dm6-package}
\alias{BSgenome.Dmelanogaster.UCSC.dm6}
\alias{Dmelanogaster}

\title{Full genome sequences for Drosophila melanogaster (UCSC version dm6)}

\description{
  Full genome sequences for Drosophila melanogaster (Fly) as provided by UCSC (dm6, Aug. 2014) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
dm6.2bit from http://hgdownload.cse.ucsc.edu/goldenPath/dm6/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Dmelanogaster.UCSC.dm6
genome <- BSgenome.Dmelanogaster.UCSC.dm6
seqlengths(genome)
genome$chr2L  # same as genome[["chr2L"]]

## ---------------------------------------------------------------------
## Extract the upstream sequences
## ---------------------------------------------------------------------
## The upstream sequences can easily be extracted from the full genome
## sequences with something like:

library(GenomicFeatures)
txdb <- makeTxDbFromUCSC("dm6", tablename="refGene")
up1000seqs <- extractUpstreamSeqs(genome, txdb, width=1000)

## IMPORTANT: Make sure you use a TxDb package (or TxDb object) that
## contains a gene model based on dm6 or on a compatible genome (i.e.
## a genome with sequences identical to the sequences in dm6). Note
## that you can make a TxDb object from various annotation resources.
## See the makeTxDbFromUCSC(), makeTxDbFromBiomart(), and
## makeTxDbFromGFF() functions in the GenomicFeatures package for more
## information.

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
