###
###

.pkgname <- "BSgenome.Hsapiens.UCSC.hg18"

.seqnames <- paste("chr", c(1:22, "X", "Y", "M", "5_h2_hap1", "6_cox_hap1", "6_qbl_hap2", "22_h2_hap1", paste(c((1:22)[-c(12, 14, 20)], "X"), "_random", sep="")), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo sapiens",
        species="Human",
        provider="UCSC",
        provider_version="hg18",
        release_date="Mar. 2006",
        release_name="NCBI Build 36.1",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/hg18/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Hsapiens"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

