\name{BSgenome.Mmusculus.UCSC.mm10}
\docType{package}

\alias{BSgenome.Mmusculus.UCSC.mm10-package}
\alias{BSgenome.Mmusculus.UCSC.mm10}
\alias{Mmusculus}

\title{Full genome sequences for Mus musculus (UCSC version mm10, based on GRCm38.p6)}

\description{
  Full genome sequences for Mus musculus (Mouse) as provided by UCSC (mm10, based on GRCm38.p6) and stored in Biostrings objects.
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
mm10.p6.2bit, downloaded from https://hgdownload.soe.ucsc.edu/goldenPath/mm10/bigZips/p6/ on July 1st, 2021
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Mmusculus.UCSC.mm10
genome <- BSgenome.Mmusculus.UCSC.mm10
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
