###
###

.pkgname <- "BSgenome.Osativa.MSU.MSU7"

.seqnames <- paste("Chr", c(1:12, "M", "C", "Un", "Sy"), sep="")

.circ_seqs <- c("ChrM", "ChrC")

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Oryza sativa",
        species="Rice",
        provider="MSU",
        provider_version="MSU7",
        release_date="October 31, 2011",
        release_name="MSU7 Genome Release",
        source_url="ftp://ftp.plantbiology.msu.edu/pub/data/Eukaryotic_Projects/o_sativa/annotation_dbs/pseudomolecules/version_7.0/all.dir/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Osativa"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

