\name{BSgenome.Osativa.MSU.MSU7}
\docType{package}

\alias{BSgenome.Osativa.MSU.MSU7-package}
\alias{BSgenome.Osativa.MSU.MSU7}
\alias{Osativa}

\title{Oryza sativa full genome (MSU7)}

\description{
  Oryza sativa full genome as provided by MSU (MSU7 Genome Release) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
ftp://ftp.plantbiology.msu.edu/pub/data/Eukaryotic_Projects/o_sativa/annotation_dbs/pseudomolecules/version_7.0/all.dir/all.con

  }
  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the BSgenome software
  package for how to make a BSgenome data package.
}

\author{Wen Yao <ywhzau@gmail.com>}

\seealso{
  \link[BSgenome]{BSgenome-class},
  \link[Biostrings]{DNAString-class},
  \code{\link[BSgenome]{available.genomes}},
  \link[BSgenome]{BSgenomeForge}
}

\examples{
BSgenome.Osativa.MSU.MSU7
genome <- BSgenome.Osativa.MSU.MSU7
seqlengths(genome)
genome$Chr1  # same as genome[["Chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
