###
###
###

.seqnames <- c(paste("TGME49_chr",c("Ia","Ib","II","III","IV","V","VI","VIIa","VIIb","VIII","IX","X","XI","XII"),sep=""),"unmappedContig")

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    extdata_dir <- system.file("extdata", package=pkgname, lib.loc=libname)
    bsgenome <- BSgenome(
        organism="Toxoplasma gondii",
        species="Toxoplasma gondii",
        provider="ToxoDB",
        provider_version="7.0",
        release_date="2011-07-2011",
        release_name="TgondiiME49_ToxoDB-7.0",
        source_url="http://toxodb.org/common/downloads/release-7.0/Tgondii/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dir=extdata_dir
    )
    objname <- "Tgondii"
    ns <- asNamespace(pkgname)
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)
}

