###
###

.pkgname <- "BSgenome.Vvinifera.URGI.IGGP12Xv2"

.seqnames <- paste("chr", c(1:19, "Ukn"), sep="")

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Vitis vinifera vinifera",
        common_name="Grape",
        provider="URGI",
        provider_version="IGGP12Xv2",
        release_date="Nov. 2013",
        release_name="IGGP 12Xv2",
        source_url="https://urgi.versailles.inra.fr/download/vitis/12Xv2_grapevine_genome_assembly.fa.gz",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Vvinifera"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

