###
###

.pkgname <- "BSgenome.Vvinifera.URGI.IGGP8X"

.seqnames <- c(paste("chr", 1:19, sep=""), paste("chr", c(1:3,7:8,10:19,"Un"), "_random", sep=""))

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Vitis vinifera vinifera",
        common_name="Grape",
        provider="URGI",
        provider_version="IGGP8X",
        release_date="Aug. 2007",
        release_name="IGGP 8X",
        source_url="https://urgi.versailles.inra.fr/download/vitis/VV_chr8x.fsa.zip",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Vvinifera"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

