SNP.color <- function(x) {
  idx = as.numeric(rownames(x))
  m.sums = colSums(methylated(ctrls)[idx,])
  u.sums = colSums(unmethylated(ctrls)[idx,])
  unique(ifelse(m.sums > u.sums, 'Grn', 'Red'))
}

hm27.SNP.controls <- hm27.controls[grep('^rs', hm27.controls$Name), ]
SNPs.split <- split(hm27.SNP.controls, gsub('_$','',hm27.SNP.controls$Name))
SNP.channel <- unlist(lapply(SNPs.split, SNP.color))
save(hm27.SNP.colors, file="hm27.SNP.colors.rda")
