\name{getPlatform}
\alias{getPlatform}
\alias{get450k}
\alias{get27k}
\title{Retrieve annotations for HumanMethylation27 or HumanMethylation450 chips}

\description{
  FDb.InfiniumMethylation.hg19 is an omnibus package that merges all of the 
  existing Illumina Infinium DNA methylation probe annotations into one FDb. 
  However, most users will be analyzing one of the two chips at any given time.
  The utility functions getPlatform(platform), get450k(), and get27k() retrieve
  a compact GenomicRanges form of the annotations for the requested platform. 
}

\author{Tim Triche, Jr.}

\examples{

  hm450.hg19 <- getPlatform(platform='HM450', genome='hg19')
  show(hm450.hg19)

  hm27.hg19 <- get27k()
  genome(hm27.hg19)

}
