\name{FDb.InfiniumMethylation.hg19}
\docType{package}

\alias{FDb.InfiniumMethylation.hg19-package}
\alias{FDb.InfiniumMethylation.hg19}

\title{Annotation package for Illumina Infinium DNA methylation probes}

\description{  
  This package loads one or more FeatureDb objects.  Such FeatureDb
  objects are an R interface to prefabricated databases contained by
  this package.  In the case of the Infinium methylation FDb, it is 
  FDb.InfiniumMethylation.hg19 (for the moment; hg18 may come later,
  or alternatively users can use liftOver() from rtracklayer to do it).
}

\author{Tim Triche, Jr.}

\seealso{
  \code{\link{getPlatform}}
  \code{\link{get450k}}
  \code{\link{get27k}}
}

\examples{

## load the library
library(FDb.InfiniumMethylation.hg19)

## list the contents that are loaded into memory
ls('package:FDb.InfiniumMethylation.hg19')

## show the db object that is loaded by calling it's name
FDb.InfiniumMethylation.hg19

## extract features for use in constructing SummarizedExperiments 
## or comparing chip features against other data (e.g. ChIP-seq)
InfiniumMethylation <- features(FDb.InfiniumMethylation.hg19)

## we'd prefer if R would stop us from comparing across assemblies:
met <- metadata(FDb.InfiniumMethylation.hg19) ## need to fetch genome
genome(InfiniumMethylation) <- met[which(met[,'name']=='Genome'),'value']

## last but not least, sort the probes in genomic order 
InfiniumMethylation <- sort(InfiniumMethylation)
show(InfiniumMethylation)

## Example: probes that overlap Irizarry's HMM CpG islands
data(hg19.islands)
CGI.probes <- subsetByOverlaps(InfiniumMethylation, hg19.islands)
head(CGI.probes)
tail(CGI.probes)

## Same as above, but now for "shores" 
hg19.shores <- c(flank(hg19.islands, 2000, start=TRUE), 
                 flank(hg19.islands, 2000, start=FALSE))
shore.probes <- subsetByOverlaps(InfiniumMethylation, hg19.shores)
head(shore.probes)
tail(shore.probes)

## The same logic works for overlapping probes with other data.
## For example, we can easily do this for old 27k data as well:
hm27 <- get27k()
hm27.shores <- subsetByOverlaps(hm27, hg19.shores)

## The same logic applies to overlapping ChIP-seq peaks, DNAseI footprints, etc.
## Much more data is available via GenomicFeatures and rtracklayer:
## help(makeFeatureDbFromUCSC)

}

\keyword{package}
\keyword{data}
