\name{FDb.UCSC.tRNAs}
\docType{package}

\alias{FDb.UCSC.tRNAs-package}
\alias{FDb.UCSC.tRNAs}
\alias{FDb.UCSC.tRNAs}
\alias{FDb.Hsapiens.UCSC.hg19.tRNAs}
\alias{FDb.Hsapiens.UCSC.hg18.tRNAs}
\alias{FDb.Mmusculus.UCSC.mm9.tRNAs}
\alias{FDb.Rnorvegicus.UCSC.rn4.tRNAs}


\title{Annotation package for FeatureDb object(s)}

\description{  
  This package loads one or more FeatureDb objects.  Such FeatureDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TranscriptDb object, of Homo Sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2012-09-10 13:15:01 -0700 (Mon, 10 Sep 2012) and based on the hg19 genome based on the tRNAs table
}

\author{Marc Carlson}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(FDb.UCSC.tRNAs)
## list the contents that are loaded into memory
ls('package:FDb.UCSC.tRNAs')
## show the db object that is loaded by calling it's name
FDb.Hsapiens.UCSC.hg19.tRNAs

}

\keyword{package}
\keyword{data}
