\name{IlluminaHumanMethylation27kCPGCOORDINATE}
\alias{IlluminaHumanMethylation27kCPGCOORDINATE}
\title{Map Manufacturer IDs to genomic coordinate}
\description{
 IlluminaHumanMethylation27kCPGCOORDINATE is an R object that provides mappings between a
 manufacturer identifier and the CpG coordinate as defined by Illumina in the manifest.
}
\details{
  Simple probe mapping to CpG coordinate within the human genome, Build 36, as defined
  by Illumina.
  
  Mappings were based on data provided by: Illimina
  http://Illumina.com
  Downloaded 19-Sep-2009
  
}

\examples{
        x <- IlluminaHumanMethylation27kCPGCOORDINATE
        # Get the probe identifiers that are mapped to a CpG coordinate
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the CHR for the first five probes
          xx[1:5]
        }
}
\keyword{datasets}

