library(minfi)

manifest <- "~/Work/cegs/450k/data_files/HumanMethylation27_270596_v.1.2.bpm"
stopifnot(file.exists(manifest))
maniTmp <- minfi:::read.manifest.27k(manifest)

## Manifest package
maniList <- maniTmp$manifestList
IlluminaHumanMethylation27kmanifest <- IlluminaMethylationManifest(TypeI = maniList$TypeI,
                                                                   TypeII = maniList$TypeII,
                                                                   TypeControl = maniList$TypeControl,
                                                                   TypeSnpI = maniList$TypeSnpI,
                                                                   TypeSnpII = maniList$TypeSnpII,
                                                                   annotation = "IlluminaHumanMethylation27k")
save(IlluminaHumanMethylation27kmanifest, compress = "xz",
     file = "IlluminaHumanMethylation27kmanifest.rda")

