\name{myPfam}
\alias{myPfam}
\docType{data}
\title{
Pfam-A for LowMACA package
}
\description{
This dataset comprises all the Pfam-A entries mapped for LowMACA
}
\usage{data("myPfam")}
\format{
A data frame with the following 11 variables.
\describe{
\item{Entry}{a character vector of Uniprot entries}
\item{Envelope_Start}{a numeric vector of starts of the pfam domain relative to the reference protein}
\item{Envelope_End}{a numeric vector of ends of the pfam domain relative to the reference protein}
\item{Pfam_ID}{a character vector of Pfam IDs in the form of PF###### supported by LowMACA}
\item{Pfam_Name}{a character vector of full Pfam domain names}
\item{Type}{a character vector. One of the following: "Domain" "Family" "Repeat" or "Motif"}
\item{Clan_ID}{a numeric vector of Clan IDs, a sort of families of Pfam domains}
\item{Entrez}{a numeric vector of Entrez IDs}
\item{UNIPROT}{a character vector of Uniprot entries in format "name_HUMAN"}
\item{Gene_Symbol}{a character vector of official Gene Symbols}
\item{Pfam_Fasta}{a character vector of amino acid sequences of corresponding Pfam}
}
}
\details{
This is the result of a merge between Pfam-A, Uniprot, HGNC databases
}
\source{
\href{http://pfam.xfam.org/}{Pfam website}
}
\examples{
#Load and show contents of myPfam
data(myPfam)
str(myPfam)
}
\keyword{datasets}
