.onLoad <- function(libname, pkgname) {
  extdata_dirpath <- system.file("extdata", package=pkgname,
                                 lib.loc=libname, mustWork=TRUE)

  ## fetch the metadata from the smallest file in the AF population, to minimize loading time
  finfo <- file.info(list.files(pattern=sprintf("%s\\.AF\\.", pkgname), path=extdata_dirpath,
                                full.names=TRUE))
  obj <- readRDS(file.path(extdata_dirpath, basename(rownames(finfo)[which.min(finfo$size)])))
  mdobj <- metadata(obj)
  stopifnot(identical(pkgname, mdobj$data_pkgname)) ## QC
  popname <- basename(rownames(finfo)[which.min(finfo$size)])
  popname <- gsub("\\..+$", "", gsub(sprintf("%s.", pkgname), "", popname))
  if (popname %in% seqlevels(mdobj$reference_genome))
    popname <- "default"

  serializedobjs <- rownames(finfo)
  names(serializedobjs) <- serializedobjs

  ## Make and export MafDb object.
  gsco <- GScores(provider=mdobj$provider,
                  provider_version=mdobj$provider_version,
                  download_url=mdobj$download_url,
                  download_date=mdobj$download_date,
                  reference_genome=mdobj$reference_genome,
                  data_pkgname=pkgname,
                  data_dirpath=extdata_dirpath,
                  data_serialized_objnames=serializedobjs,
                  default_pop="AF",
                  data_group="MAF",
                  data_tag="ExAC")
  gscopops <- get(pkgname, envir=gsco@.data_cache)
  gscopops[[popname]] <- RleList(compress=FALSE)
  gscopops[[popname]][[mdobj$seqname]] <- obj
  assign(pkgname, gscopops, envir=gsco@.data_cache)

  ns <- asNamespace(pkgname)
  assign(pkgname, gsco, envir=ns)

  namespaceExport(ns, pkgname)
}

.onAttach <- function(libname, pkgname) {
  msg <- paste("WARNING: The positions associated with the genomic scores stored in the",
               sprintf("%s package were lifted from the", pkgname),
               "GRCh37 release of the human genome, over to the GRCh38 release. This",
               "means that these scores were not directly derived from the GRCh38 human",
               "genome reference sequence.", sep="\n")
  packageStartupMessage(msg)
}
