\name{MafDb.TOPMed.freeze5.hg38-package}
\alias{MafDb.TOPMed.freeze5.hg38-package}
\alias{MafDb.TOPMed.freeze5.hg38}
\docType{package}

\title{
Annotation package for minor allele frequency data from NHLBI TOPMed freeze5
}
\description{
This annotation package stores minor allele frequency (MAF) data from the NHLBI TOPMed consortium, freeze5 version. The data are exposed to the user in the form of a \code{\link[GenomicScores]{GScores}} object, named after the package and loaded into memory only as different chromosomes and populations are being queried. The class definition and methods to access \code{\link[GenomicScores]{GScores}} objects are found in the \code{\link[GenomicScores]{GenomicScores}} software package. To minimize disk space and memory requirements, MAF values larger or equal than 0.1 are stored using two significant digits, while MAF values smaller than 0.1 are stored using one significant digit.

Please consult the TOPMed page at \url{https://bravo.sph.umich.edu} before you use these data for your own research.
}

\format{
  \tabular{ll}{
    \code{MafDb.TOPMed.freeze5.hg38} \tab \code{\link[GenomicScores]{GScores}} object containing MAF values from the NHLBI TOPMed Consortium downloaded on March 2019 from \url{https://bravo.sph.umich.edu/freeze5/hg38/download/all}. See the \code{inst/extadata/README} file from the source code for more information on how these data have been stored into this annnotation package. \cr
  }
}

\author{
R. Castelo
}

\seealso{
  \link[GenomicScores]{GScores-class}
  \link[GenomicScores]{gscores}
  \link[GenomicScores]{GenomicScores}
}

\examples{
library(SNPlocs.Hsapiens.dbSNP149.GRCh38)
library(MafDb.TOPMed.freeze5.hg38)

ls("package:MafDb.TOPMed.freeze5.hg38")

mafdb <- MafDb.TOPMed.freeze5.hg38
mafdb
citation(mafdb)

populations(mafdb)

## lookup allele frequencies for rs1129038, a SNP associated to blue and brown eye colors
## as reported by Eiberg et al. Blue eye color in humans may be caused by a perfectly associated
## founder mutation in a regulatory element located within the HERC2 gene inhibiting OCA2 expression.
## Human Genetics, 123(2):177-87, 2008 [http://www.ncbi.nlm.nih.gov/pubmed/18172690]

snpdb <- SNPlocs.Hsapiens.dbSNP149.GRCh38
rng <- snpsById(snpdb, ids="rs1129038")
rng
seqlevelsStyle(rng) <- seqlevelsStyle(mafdb)
gscores(mafdb, rng)
gscores(mafdb, GRanges("chr15:28111713"))
}

\source{
  The NHLBI TOPMed Consortium. Trans-Omics for Precision Medicine (TOPMed), Ann Arbor, USA
  (URL: \url{https://bravo.sph.umich.edu}) [October, 2019, accessed]
}

\keyword{package}
\keyword{data}
