datacache <- new.env(hash=TRUE, parent=emptyenv())

MmAgilentDesign026655 <- function() showQCData("MmAgilentDesign026655", datacache)
MmAgilentDesign026655_dbconn <- function() dbconn(datacache)
MmAgilentDesign026655_dbfile <- function() dbfile(datacache)
MmAgilentDesign026655_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
MmAgilentDesign026655_dbInfo <- function() dbInfo(datacache)

MmAgilentDesign026655ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "MmAgilentDesign026655.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "MmAgilentDesign026655", "chip MmAgilentDesign026655", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("MmAgilentDesign026655.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(MmAgilentDesign026655_dbconn())
}

