#!/bin/sh
#
# To run this script in "batch" mode:
#   ./build_OnDiskLongTable.sh >build_OnDiskLongTable.log 2>&1 &
#

set -e  # Exit immediately if a simple command exits with a non-zero status

## Settings for the rhinos:
PKGNAME="SNPlocs.Hsapiens.dbSNP150.GRCh38"
SNPLOCSFORGE_DIR="/fh/fast/morgan_m/BioC/SNPlocsForge"
TOOLS_DIR="$SNPLOCSFORGE_DIR/svn/$PKGNAME/inst/tools"
TMP_DIR="$SNPLOCSFORGE_DIR/srcdata/$PKGNAME/tmp_files"

#SEQNAMES="22 MT"
SEQNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y MT"

R="$HOME/bin/R"
R_SCRIPT0="source('$TOOLS_DIR/build_OnDiskLongTable.R')"

R_SCRIPT="$R_SCRIPT0; build_OnDiskLongTable('$TMP_DIR', '$SEQNAMES')"
echo "$R_SCRIPT" | $R --vanilla

