\name{TxDb.Rnorvegicus.UCSC.rn4.ensGene}
\docType{package}

\alias{TxDb.Rnorvegicus.UCSC.rn4.ensGene-package}
\alias{TxDb.Rnorvegicus.UCSC.rn4.ensGene}
\alias{TxDb.Rnorvegicus.UCSC.rn4.ensGene}


\title{Annotation package for TxDb object(s)}

\description{  
  This package loads one or more TxDb objects.  Such TxDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TxDb object, of Homo sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2015-10-07 18:17:49 +0000 (Wed, 07 Oct 2015) and based on the rn4 genome based on the ensGene table
}

\author{Marc Carlson, Bioconductor Package Maintainer <maintainer@bioconductor.org> [cre]}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(TxDb.Rnorvegicus.UCSC.rn4.ensGene)
## list the contents that are loaded into memory
ls('package:TxDb.Rnorvegicus.UCSC.rn4.ensGene')
## show the db object that is loaded by calling it's name
TxDb.Rnorvegicus.UCSC.rn4.ensGene

}

\keyword{package}
\keyword{data}
