
\name{clariomdhumantranscriptcluster_dbconn}

\alias{clariomdhumantranscriptcluster_dbconn}
\alias{clariomdhumantranscriptcluster_dbfile}
\alias{clariomdhumantranscriptcluster_dbschema}
\alias{clariomdhumantranscriptcluster_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  clariomdhumantranscriptcluster_dbconn()
  clariomdhumantranscriptcluster_dbfile()
  clariomdhumantranscriptcluster_dbschema(file="", show.indices=FALSE)
  clariomdhumantranscriptcluster_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{clariomdhumantranscriptcluster_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{clariomdhumantranscriptcluster_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{clariomdhumantranscriptcluster_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{clariomdhumantranscriptcluster_dbschema} prints the schema definition of the
  package annotation DB.

  \code{clariomdhumantranscriptcluster_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{clariomdhumantranscriptcluster_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{clariomdhumantranscriptcluster_dbfile}: a character string with the path to the
  package annotation DB.

  \code{clariomdhumantranscriptcluster_dbschema}: none (invisible \code{NULL}).

  \code{clariomdhumantranscriptcluster_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(clariomdhumantranscriptcluster_dbconn(), "SELECT COUNT(*) FROM probes")

  clariomdhumantranscriptcluster_dbschema()

  clariomdhumantranscriptcluster_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

