datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomsmousetranscriptcluster <- function() showQCData("clariomsmousetranscriptcluster", datacache)
clariomsmousetranscriptcluster_dbconn <- function() dbconn(datacache)
clariomsmousetranscriptcluster_dbfile <- function() dbfile(datacache)
clariomsmousetranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomsmousetranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomsmousetranscriptclusterORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomsmousetranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "clariomsmousetranscriptcluster", "chip clariomsmousetranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomsmousetranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomsmousetranscriptcluster_dbconn())
}

