
\name{clariomsmousetranscriptcluster_dbconn}

\alias{clariomsmousetranscriptcluster_dbconn}
\alias{clariomsmousetranscriptcluster_dbfile}
\alias{clariomsmousetranscriptcluster_dbschema}
\alias{clariomsmousetranscriptcluster_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  clariomsmousetranscriptcluster_dbconn()
  clariomsmousetranscriptcluster_dbfile()
  clariomsmousetranscriptcluster_dbschema(file="", show.indices=FALSE)
  clariomsmousetranscriptcluster_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{clariomsmousetranscriptcluster_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{clariomsmousetranscriptcluster_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{clariomsmousetranscriptcluster_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{clariomsmousetranscriptcluster_dbschema} prints the schema definition of the
  package annotation DB.

  \code{clariomsmousetranscriptcluster_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{clariomsmousetranscriptcluster_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{clariomsmousetranscriptcluster_dbfile}: a character string with the path to the
  package annotation DB.

  \code{clariomsmousetranscriptcluster_dbschema}: none (invisible \code{NULL}).

  \code{clariomsmousetranscriptcluster_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(clariomsmousetranscriptcluster_dbconn(), "SELECT COUNT(*) FROM probes")

  clariomsmousetranscriptcluster_dbschema()

  clariomsmousetranscriptcluster_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

