datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomsrathttranscriptcluster <- function() showQCData("clariomsrathttranscriptcluster", datacache)
clariomsrathttranscriptcluster_dbconn <- function() dbconn(datacache)
clariomsrathttranscriptcluster_dbfile <- function() dbfile(datacache)
clariomsrathttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomsrathttranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomsrathttranscriptclusterORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomsrathttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "clariomsrathttranscriptcluster", "chip clariomsrathttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomsrathttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomsrathttranscriptcluster_dbconn())
}

