
\name{hgu133a_dbconn}

\alias{hgu133a_dbconn}
\alias{hgu133a_dbfile}
\alias{hgu133a_dbschema}
\alias{hgu133a_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hgu133a_dbconn()
  hgu133a_dbfile()
  hgu133a_dbschema(file="", show.indices=FALSE)
  hgu133a_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hgu133a_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hgu133a_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hgu133a_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hgu133a_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hgu133a_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hgu133a_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hgu133a_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hgu133a_dbschema}: none (invisible \code{NULL}).

  \code{hgu133a_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hgu133a_dbconn(), "SELECT COUNT(*) FROM probes")

  hgu133a_dbschema()

  hgu133a_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

