\name{hgu95av2CHR}
\alias{hgu95av2CHR}
\title{Map Manufacturer IDs to Chromosomes}
\description{
 hgu95av2CHR is an R environment that provides mappings between a
 manufacturer identifier and the chromosome that contains the gene of interest. 
}
\details{
  Each manufacturer identifier maps to a vector of chromosomes. Due to
  inconsistencies that may exist at the time the environment was built,
  the vector may contain more than one chromosome (e.g., the identifier may map
  to more than one chromosome). If the chromosomal location is unknown,
  the vector will contain an \code{NA}.
  
  Mappings were based on data provided by:
  
  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007
  
  Package built: Thu Mar 15 21:19:18 2007
}

\examples{
        # Convert to a list
        xx <- as.list(hgu95av2CHR)
        # Remove probe identifiers that do not map to any CHRLOC
        xx <- xx[!is.na(xx)]
        if(length(xx) > 0){
            # Get the chromosome number for the first five probes
            xx[1:5]
            # Get the first one
            xx[[1]]
        }
}
\keyword{datasets}

