\name{hgu95av2ENTREZID}
\alias{hgu95av2ENTREZID}
\alias{hgu95av2LOCUSID}
\title{Map between Manufacturer Identifiers and Entrez Gene}
\description{
  hgu95av2ENTREZID is an R environment that provides mappings between
  manufacturer identifiers and Entrez Gene identifiers.
}
\details{
  Each manufacturer identifier is mapped to a vector of Entrez Gene identifiers. An
  \code{NA} is assigned to those manufacturer identifiers that can not be mapped
  to an Entrez Gene identifier at this time.
  
  If a given manufacturer identifier can be mapped to different Entrez Gene identifiers
  from various sources, we attempt to select the common identifiers. If a
  concensus cannot be determined, we select the smallest identifier.
  
  Mappings were based on data provided by:

  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007
  
  Package built: Thu Mar 15 21:19:18 2007
}
\references{
\url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(hgu95av2ENTREZID)
    # Remove probe identifiers that do not map to any ENTREZID
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # The ENTREZIDs for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
    }
}

\keyword{datasets}

