\name{hgu95av2GENENAME}
\alias{hgu95av2GENENAME}
\title{Map Between Manufacturer IDs and Genes}
\description{
  hgu95av2GENENAME is an R environment that maps manufacturer
  identifiers to the corresponding gene name.
}
\details{
  Each manufacturer identifier maps to a named vector containing the gene
  name. The vector name corresponds to the manufacturer identifier. If the gene
  name is unknown, the vector will contain an \code{NA}.
  
  Gene names currently include both the official (validated by a
  nomenclature committee) and preferred names (interim selected for
  display) for genes. Efforts are being made to differentiate the two
  by adding a name to the vector.

  Mappings were based on data provided by:

  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007
  
  Package built Thu Mar 15 21:19:18 2007
}

\examples{
     # Convert to a list
     xx <- as.list(hgu95av2GENENAME)
     # Remove probes that do not map to any GENENAME
     xx <- xx[!is.na(xx)]
     if(length(xx) > 0){
         # Gets the gene names for the first five probe identifiers
         xx[1:5]
         # Get the first one
         xx[[1]]
     }
}
\keyword{datasets}

