datacache <- new.env(hash=TRUE, parent=emptyenv())

hguatlas13k <- function() showQCData("hguatlas13k", datacache)
hguatlas13k_dbconn <- function() dbconn(datacache)
hguatlas13k_dbfile <- function() dbfile(datacache)
hguatlas13k_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hguatlas13k_dbInfo <- function() dbInfo(datacache)

hguatlas13kORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hguatlas13k.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hguatlas13k", "chip hguatlas13k", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hguatlas13k.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hguatlas13k_dbconn())
}

