datacache <- new.env(hash=TRUE, parent=emptyenv())

hu35ksubd <- function() showQCData("hu35ksubd", datacache)
hu35ksubd_dbconn <- function() dbconn(datacache)
hu35ksubd_dbfile <- function() dbfile(datacache)
hu35ksubd_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hu35ksubd_dbInfo <- function() dbInfo(datacache)

hu35ksubdORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hu35ksubd.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hu35ksubd", "chip hu35ksubd", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hu35ksubd.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hu35ksubd_dbconn())
}

