datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanWGDASLv3 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanWGDASLv3", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanWGDASLv3listNewMappings()

}

illuminaHumanWGDASLv3_dbconn <- function() dbconn(datacache)
illuminaHumanWGDASLv3_dbfile <- function() dbfile(datacache)
illuminaHumanWGDASLv3_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanWGDASLv3_dbInfo <- function() dbInfo(datacache)

illuminaHumanWGDASLv3ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanWGDASLv3.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanWGDASLv3", "chip illuminaHumanWGDASLv3", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanWGDASLv3.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanWGDASLv3_dbconn())
}

##Custom Bimaps for the package

illuminaHumanWGDASLv3ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanWGDASLv3.db")

illuminaHumanWGDASLv3listNewMappings = function(){
cat("illuminaHumanWGDASLv3ARRAYADDRESS()\n") 
cat("illuminaHumanWGDASLv3NUID()\n") 
cat("illuminaHumanWGDASLv3PROBEQUALITY()\n") 
cat("illuminaHumanWGDASLv3CODINGZONE()\n") 
cat("illuminaHumanWGDASLv3PROBESEQUENCE()\n") 
cat("illuminaHumanWGDASLv3SECONDMATCHES()\n") 
cat("illuminaHumanWGDASLv3OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanWGDASLv3REPEATMASK()\n") 
cat("illuminaHumanWGDASLv3OVERLAPPINGSNP()\n") 
cat("illuminaHumanWGDASLv3ENTREZREANNOTATED()\n") 
cat("illuminaHumanWGDASLv3GENOMICLOCATION()\n") 
cat("illuminaHumanWGDASLv3SYMBOLREANNOTATED()\n") 
cat("illuminaHumanWGDASLv3REPORTERGROUPNAME()\n") 
cat("illuminaHumanWGDASLv3REPORTERGROUPID()\n") 
cat("illuminaHumanWGDASLv3ENSEMBLREANNOTATED()\n") 
}
illuminaHumanWGDASLv3fullReannotation = function(){
dbGetQuery(illuminaHumanWGDASLv3_dbconn(), "SELECT * FROM ExtraInfo")
}
