datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanWGDASLv4 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanWGDASLv4", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanWGDASLv4listNewMappings()

}

illuminaHumanWGDASLv4_dbconn <- function() dbconn(datacache)
illuminaHumanWGDASLv4_dbfile <- function() dbfile(datacache)
illuminaHumanWGDASLv4_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanWGDASLv4_dbInfo <- function() dbInfo(datacache)

illuminaHumanWGDASLv4ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanWGDASLv4.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanWGDASLv4", "chip illuminaHumanWGDASLv4", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanWGDASLv4.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanWGDASLv4_dbconn())
}

##Custom Bimaps for the package

illuminaHumanWGDASLv4ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanWGDASLv4.db")

illuminaHumanWGDASLv4listNewMappings = function(){
cat("illuminaHumanWGDASLv4ARRAYADDRESS()\n") 
cat("illuminaHumanWGDASLv4NUID()\n") 
cat("illuminaHumanWGDASLv4PROBEQUALITY()\n") 
cat("illuminaHumanWGDASLv4CODINGZONE()\n") 
cat("illuminaHumanWGDASLv4PROBESEQUENCE()\n") 
cat("illuminaHumanWGDASLv4SECONDMATCHES()\n") 
cat("illuminaHumanWGDASLv4OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanWGDASLv4REPEATMASK()\n") 
cat("illuminaHumanWGDASLv4OVERLAPPINGSNP()\n") 
cat("illuminaHumanWGDASLv4ENTREZREANNOTATED()\n") 
cat("illuminaHumanWGDASLv4GENOMICLOCATION()\n") 
cat("illuminaHumanWGDASLv4SYMBOLREANNOTATED()\n") 
cat("illuminaHumanWGDASLv4REPORTERGROUPNAME()\n") 
cat("illuminaHumanWGDASLv4REPORTERGROUPID()\n") 
cat("illuminaHumanWGDASLv4ENSEMBLREANNOTATED()\n") 
}
illuminaHumanWGDASLv4fullReannotation = function(){
dbGetQuery(illuminaHumanWGDASLv4_dbconn(), "SELECT * FROM ExtraInfo")
}
