datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanv4 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanv4", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanv4listNewMappings()

}
illuminaHumanv4_dbconn <- function() dbconn(datacache)
illuminaHumanv4_dbfile <- function() dbfile(datacache)
illuminaHumanv4_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanv4_dbInfo <- function() dbInfo(datacache)

illuminaHumanv4ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanv4.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanv4", "chip illuminaHumanv4", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanv4.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanv4_dbconn())
}

##Custom Bimaps for the package

illuminaHumanv4ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanv4.db")

illuminaHumanv4NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanv4.db")

illuminaHumanv4PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanv4.db")

illuminaHumanv4CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanv4.db")

illuminaHumanv4PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanv4.db")

illuminaHumanv4SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanv4.db")

illuminaHumanv4OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanv4.db")

illuminaHumanv4REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanv4.db")

illuminaHumanv4OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanv4.db")

illuminaHumanv4ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanv4.db")

illuminaHumanv4GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanv4.db")

illuminaHumanv4SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanv4.db")

illuminaHumanv4REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanv4.db")

illuminaHumanv4REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanv4.db")

illuminaHumanv4ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanv4.db")

illuminaHumanv4listNewMappings = function(){
cat("illuminaHumanv4ARRAYADDRESS()\n") 
cat("illuminaHumanv4NUID()\n") 
cat("illuminaHumanv4PROBEQUALITY()\n") 
cat("illuminaHumanv4CODINGZONE()\n") 
cat("illuminaHumanv4PROBESEQUENCE()\n") 
cat("illuminaHumanv4SECONDMATCHES()\n") 
cat("illuminaHumanv4OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanv4REPEATMASK()\n") 
cat("illuminaHumanv4OVERLAPPINGSNP()\n") 
cat("illuminaHumanv4ENTREZREANNOTATED()\n") 
cat("illuminaHumanv4GENOMICLOCATION()\n") 
cat("illuminaHumanv4SYMBOLREANNOTATED()\n") 
cat("illuminaHumanv4REPORTERGROUPNAME()\n") 
cat("illuminaHumanv4REPORTERGROUPID()\n") 
cat("illuminaHumanv4ENSEMBLREANNOTATED()\n") 
}
illuminaHumanv4fullReannotation = function(){
dbGetQuery(illuminaHumanv4_dbconn(), "SELECT * FROM ExtraInfo")
}
