datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaMousev1 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaMousev1", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaMousev1listNewMappings()
}
illuminaMousev1_dbconn <- function() dbconn(datacache)
illuminaMousev1_dbfile <- function() dbfile(datacache)
illuminaMousev1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaMousev1_dbInfo <- function() dbInfo(datacache)

illuminaMousev1ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaMousev1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "illuminaMousev1", "chip illuminaMousev1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaMousev1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaMousev1_dbconn())
}

##Custom Bimaps for the package

illuminaMousev1ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaMousev1.db")

illuminaMousev1PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaMousev1.db")

illuminaMousev1REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaMousev1.db")

illuminaMousev1REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaMousev1.db")

illuminaMousev1NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaMousev1.db")

illuminaMousev1PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaMousev1.db")

illuminaMousev1CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaMousev1.db")

illuminaMousev1SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaMousev1.db")

illuminaMousev1OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaMousev1.db")

illuminaMousev1REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaMousev1.db")

illuminaMousev1OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaMousev1.db")

illuminaMousev1ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaMousev1.db")

illuminaMousev1GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaMousev1.db")

illuminaMousev1SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaMousev1.db")

illuminaMousev1ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaMousev1.db")

illuminaMousev1listNewMappings = function(){
cat("illuminaMousev1ARRAYADDRESS()\n") 
cat("illuminaMousev1PROBESEQUENCE()\n") 
cat("illuminaMousev1REPORTERGROUPNAME()\n") 
cat("illuminaMousev1REPORTERGROUPID()\n") 
cat("illuminaMousev1NUID()\n") 
cat("illuminaMousev1PROBEQUALITY()\n") 
cat("illuminaMousev1CODINGZONE()\n") 
cat("illuminaMousev1SECONDMATCHES()\n") 
cat("illuminaMousev1OTHERGENOMICMATCHES()\n") 
cat("illuminaMousev1REPEATMASK()\n") 
cat("illuminaMousev1OVERLAPPINGSNP()\n") 
cat("illuminaMousev1ENTREZREANNOTATED()\n") 
cat("illuminaMousev1GENOMICLOCATION()\n") 
cat("illuminaMousev1SYMBOLREANNOTATED()\n") 
cat("illuminaMousev1ENSEMBLREANNOTATED()\n") 
}
illuminaMousev1fullReannotation = function(){
dbGetQuery(illuminaMousev1_dbconn(), "SELECT * FROM ExtraInfo")
}
