datacache <- new.env(hash=TRUE, parent=emptyenv())

lumiRatIDMapping <- function() {
	tableNames <- dbListTables(lumiRatIDMapping_dbconn())
	tableNames <- tableNames[!(tableNames %in% c('nuID_MappingInfo', 'metadata'))]
	cat('Database includes ID mapping information of following manifest files:\n\t')
	cat(tableNames, sep='\n\t')
	cat("\nIt also includes their nuID mapping information.\n For more details, please type lumiRatIDMapping_nuID().\n")
}

lumiRatIDMapping_nuID <- function() {
	tableNames <- dbListTables(lumiRatIDMapping_dbconn())
	tt <- dbReadTable(lumiRatIDMapping_dbconn(), 'nuID_MappingInfo')
	fieldNames <- dbListFields(lumiRatIDMapping_dbconn(), 'nuID_MappingInfo')
	cat(paste('nuID_MappingInfo table includes', nrow(tt), 'unique Rattus norvegicus Illumina probes mapping information.\n'))
	cat(paste('\nThe table includes following fields (see help(lumiRatIDMapping_nuID) for detailed definition.):\n'))
	cat(fieldNames, sep='\n\t')
}


lumiRatIDMapping_dbconn <- function() dbconn(datacache)
lumiRatIDMapping_dbfile <- function() dbfile(datacache)
lumiRatIDMapping_dbInfo <- function() dbInfo(datacache)

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiRatIDMapping.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiRatIDMapping_dbconn())
}

