\name{lumiRatIDMapping_dbconn}

\alias{lumiRatIDMapping_dbconn}
\alias{lumiRatIDMapping_dbfile}
\alias{lumiRatIDMapping_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  lumiRatIDMapping_dbconn()
  lumiRatIDMapping_dbfile()
  lumiRatIDMapping_dbInfo()
}

\arguments{
 
}

\details{
  \code{lumiRatIDMapping_dbconn} returns a connection object to the package
  annotation DB.
  IMPORTANT: Don't call \code{\link[DBI]{dbDisconnect}} on the connection
  object returned by \code{lumiRatIDMapping_dbconn} or you will
  break all the \code{\link[AnnotationDbi]{AnnDbObj}} objects defined in this package!

  \code{lumiRatIDMapping_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{lumiRatIDMapping_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{lumiRatIDMapping_dbconn}: a DBIConnection object representing an open
  connection to the package annotation DB.

  \code{lumiRatIDMapping_dbfile}: a character string with the path to the
  package annotation DB.

  \code{lumiRatIDMapping_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI]{dbConnect}}
}

\examples{
  ## Show the database information (meta data)
  lumiRatIDMapping_dbInfo()  

  ## List the tables included in the database
  conn <- lumiRatIDMapping_dbconn()
  dbListTables(conn)
}

\keyword{utilities}
\keyword{datasets}

