
\name{mm24kresogen_dbconn}

\alias{mm24kresogen_dbconn}
\alias{mm24kresogen_dbfile}
\alias{mm24kresogen_dbschema}
\alias{mm24kresogen_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  mm24kresogen_dbconn()
  mm24kresogen_dbfile()
  mm24kresogen_dbschema(file="", show.indices=FALSE)
  mm24kresogen_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{mm24kresogen_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{mm24kresogen_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{mm24kresogen_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{mm24kresogen_dbschema} prints the schema definition of the
  package annotation DB.

  \code{mm24kresogen_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{mm24kresogen_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{mm24kresogen_dbfile}: a character string with the path to the
  package annotation DB.

  \code{mm24kresogen_dbschema}: none (invisible \code{NULL}).

  \code{mm24kresogen_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(mm24kresogen_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by mm24kresogen_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=mm24kresogen_dbfile(), cache_size=64000,
  synchronous=0)

  mm24kresogen_dbschema()

  mm24kresogen_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

