datacache <- new.env(hash=TRUE, parent=emptyenv())

mta10transcriptcluster <- function() showQCData("mta10transcriptcluster", datacache)
mta10transcriptcluster_dbconn <- function() dbconn(datacache)
mta10transcriptcluster_dbfile <- function() dbfile(datacache)
mta10transcriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mta10transcriptcluster_dbInfo <- function() dbInfo(datacache)

mta10transcriptclusterORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mta10transcriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mta10transcriptcluster", "chip mta10transcriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mta10transcriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mta10transcriptcluster_dbconn())
}

