
\name{mu11ksuba_dbconn}

\alias{mu11ksuba_dbconn}
\alias{mu11ksuba_dbfile}
\alias{mu11ksuba_dbschema}
\alias{mu11ksuba_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  mu11ksuba_dbconn()
  mu11ksuba_dbfile()
  mu11ksuba_dbschema(file="", show.indices=FALSE)
  mu11ksuba_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{mu11ksuba_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{mu11ksuba_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{mu11ksuba_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{mu11ksuba_dbschema} prints the schema definition of the
  package annotation DB.

  \code{mu11ksuba_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{mu11ksuba_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{mu11ksuba_dbfile}: a character string with the path to the
  package annotation DB.

  \code{mu11ksuba_dbschema}: none (invisible \code{NULL}).

  \code{mu11ksuba_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(mu11ksuba_dbconn(), "SELECT COUNT(*) FROM probes")

  mu11ksuba_dbschema()

  mu11ksuba_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

