datacache <- new.env(hash=TRUE, parent=emptyenv())

mu19ksuba <- function() showQCData("mu19ksuba", datacache)
mu19ksuba_dbconn <- function() dbconn(datacache)
mu19ksuba_dbfile <- function() dbfile(datacache)
mu19ksuba_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mu19ksuba_dbInfo <- function() dbInfo(datacache)

mu19ksubaORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mu19ksuba.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mu19ksuba", "chip mu19ksuba", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mu19ksuba.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mu19ksuba_dbconn())
}

