datacache <- new.env(hash=TRUE, parent=emptyenv())

mu19ksubc <- function() showQCData("mu19ksubc", datacache)
mu19ksubc_dbconn <- function() dbconn(datacache)
mu19ksubc_dbfile <- function() dbfile(datacache)
mu19ksubc_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mu19ksubc_dbInfo <- function() dbInfo(datacache)

mu19ksubcORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mu19ksubc.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mu19ksubc", "chip mu19ksubc", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mu19ksubc.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mu19ksubc_dbconn())
}

