datacache <- new.env(hash=TRUE, parent=emptyenv())

nugohs1a520180 <- function() showQCData("nugohs1a520180", datacache)
nugohs1a520180_dbconn <- function() dbconn(datacache)
nugohs1a520180_dbfile <- function() dbfile(datacache)
nugohs1a520180_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
nugohs1a520180_dbInfo <- function() dbInfo(datacache)

nugohs1a520180ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "nugohs1a520180.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "nugohs1a520180", "chip nugohs1a520180", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("nugohs1a520180.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(nugohs1a520180_dbconn())
}

