\name{org.At.tairCHR}
\alias{org.At.tairCHR}
\title{Map TAIR IDs to Chromosomes}
\description{
 org.At.tairCHR is an R object that provides mappings between a
 TAIR identifier and the chromosome that contains the gene of interest. 
}
\details{
  Each TAIR identifier maps to a vector of chromosomes. Due to
  inconsistencies that may exist at the time the object was built,
  the vector may contain more than one chromosome (e.g., the identifier may map
  to more than one chromosome). If the chromosomal location is unknown,
  the vector will contain an \code{NA}.
  
  Mappings were based on data provided by: Tair  
  https://www.arabidopsis.org/api/download-files/download?filePath=Genes/TAIR10\_genome\_release/TAIR10\_functional\_descriptions  
  With a date stamp from the source of: 2025-09-24
  
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
x <- org.At.tairCHR
# Get the tair identifiers that are mapped to a chromosome
mapped_tairs <- mappedkeys(x)
# Convert to a list
xx <- as.list(x[mapped_tairs])
if(length(xx) > 0) {
  # Get the CHR for the first five tairs
  xx[1:5]
  # Get the first one
  xx[[1]]
}
}
\keyword{datasets}

