datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Mmu.eg <- function() showQCData("org.Mmu.eg", datacache)
org.Mmu.eg_dbconn <- function() dbconn(datacache)
org.Mmu.eg_dbfile <- function() dbfile(datacache)
org.Mmu.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Mmu.eg_dbInfo <- function() dbInfo(datacache)

org.Mmu.egORGANISM <- "Macaca mulatta"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Mmu.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RHESUS_DB", "org.Mmu.eg", "Rhesus", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Mmu.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Mmu.eg_dbconn())
}

