datacache <- new.env(hash=TRUE, parent=emptyenv())

rae230b <- function() showQCData("rae230b", datacache)
rae230b_dbconn <- function() dbconn(datacache)
rae230b_dbfile <- function() dbfile(datacache)
rae230b_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rae230b_dbInfo <- function() dbInfo(datacache)

rae230bORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rae230b.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rae230b", "chip rae230b", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("rae230b.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rae230b_dbconn())
}

