datacache <- new.env(hash=TRUE, parent=emptyenv())

ragene11sttranscriptcluster <- function() showQCData("ragene11sttranscriptcluster", datacache)
ragene11sttranscriptcluster_dbconn <- function() dbconn(datacache)
ragene11sttranscriptcluster_dbfile <- function() dbfile(datacache)
ragene11sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ragene11sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

ragene11sttranscriptclusterORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ragene11sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "ragene11sttranscriptcluster", "chip ragene11sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ragene11sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ragene11sttranscriptcluster_dbconn())
}

