datacache <- new.env(hash=TRUE, parent=emptyenv())

ragene20stprobeset <- function() showQCData("ragene20stprobeset", datacache)
ragene20stprobeset_dbconn <- function() dbconn(datacache)
ragene20stprobeset_dbfile <- function() dbfile(datacache)
ragene20stprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ragene20stprobeset_dbInfo <- function() dbInfo(datacache)

ragene20stprobesetORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ragene20stprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "ragene20stprobeset", "chip ragene20stprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ragene20stprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ragene20stprobeset_dbconn())
}

