meta = data.frame(
    Title = c(
        'benchmark.set.1.rds',
        'benchmark.set.2.rds',
        'benchmark.set.3.rds',
        'regr.rds',
        'regr.no.CV.rds'
    ),
    Description = c(
        'PSMs in Benchmark Set 1 (E. coli and human proteins) derived from the psm.tsv output files generated by FragPipe, which are used to train the random forest model. Columns unnecessary for the AWAggregator have been removed from the sample data.',
        'PSMs in Benchmark Set 2 (yeast and human proteins) derived from the psm.tsv output files generated by FragPipe, which are used to train the random forest model. Columns unnecessary for the AWAggregator have been removed from the sample data.',
        'PSMs in Benchmark Set 3 (yeast and human proteins) derived from the psm.tsv output files generated by FragPipe, which are used to train the random forest model. Columns unnecessary for the AWAggregator have been removed from the sample data.',
        'Pre-trained random forest model that incorporates the average coefficient of variation as a feature. The model is generated using AWAggregator (version 0.0.0.9100) with seed = 1000 in merged_training_sets function.',
        'Pre-trained random forest model that does not include the average coefficient of variation as a feature. The model is generated using AWAggregator (version 0.0.0.9100) with seed = 1000 in merged_training_sets function.'
    ),
    BiocVersion = '3.21',
    Genome = NA,
    SourceType = 'RDS',
    SourceUrl = 'https://zenodo.org/records/15128039/files/',
    SourceVersion = '0.99.0',
    Species = NA,
    TaxonomyId = NA,
    Coordinate_1_based = NA,
    DataProvider = 'University of British Columbia',
    Maintainer = 'Jiahua Tan jiahuatan@chem.ubc.ca',
    RDataClass = c('data.frame', 'data.frame', 'data.frame', 'ranger', 'ranger'),
    DispatchClass = 'Rds',
    Location_Prefix = 'https://zenodo.org/',
    RDataPath = c(
        'records/15128039/files/benchmark.set.1.rds',
        'records/15128039/files/benchmark.set.2.rds',
        'records/15128039/files/benchmark.set.3.rds',
        'records/15128039/files/regr.rds',
        'records/15128039/files/regr.no.CV.rds'
    ),
    Tags = ''
)

write.csv(meta, file = 'inst/extdata/metadata.csv', row.names = FALSE)
